#include <config.h>
#include <assert.h>
#include "search.h"
#define NCHAR (UCHAR_MAX + 1)
void
kwsinit (kwset_t *kwset)
{
  static char trans[NCHAR];
  int i;
  if (match_icase
#if MBS_SUPPORT
      && MB_CUR_MAX == 1
#endif
     )
    {
      for (i = 0; i < NCHAR; ++i)
        trans[i] = tolower (i);
      *kwset = kwsalloc (trans);
    }
  else
    *kwset = kwsalloc (NULL);
  if (!*kwset)
    xalloc_die ();
}
#if MBS_SUPPORT
char *
mbtolower (const char *beg, size_t *n)
{
  static char *out;
  static size_t outalloc;
  size_t outlen, mb_cur_max;
  mbstate_t is, os;
  const char *end;
  char *p;
  if (*n > outalloc || outalloc == 0)
    {
      outalloc = MAX(1, *n);
      out = xrealloc (out, outalloc);
    }
  assert (out);
  if (*n == 0)
    return out;
  memset (&is, 0, sizeof (is));
  memset (&os, 0, sizeof (os));
  end = beg + *n;
  mb_cur_max = MB_CUR_MAX;
  p = out;
  outlen = 0;
  while (beg < end)
    {
      wchar_t wc;
      size_t mbclen = mbrtowc(&wc, beg, end - beg, &is);
      if (outlen + mb_cur_max >= outalloc)
        {
          out = x2nrealloc (out, &outalloc, 1);
          p = out + outlen;
        }
      if (mbclen == (size_t) -1 || mbclen == (size_t) -2 || mbclen == 0)
        {
          *p++ = *beg++;
          outlen++;
          memset (&is, 0, sizeof (is));
          memset (&os, 0, sizeof (os));
        }
      else
        {
          beg += mbclen;
          mbclen = wcrtomb (p, towlower ((wint_t) wc), &os);
          p += mbclen;
          outlen += mbclen;
        }
    }
  *n = p - out;
  *p = 0;
  return out;
}
bool
is_mb_middle (const char **good, const char *buf, const char *end,
              size_t match_len)
{
  const char *p = *good;
  const char *prev = p;
  mbstate_t cur_state;
  memset(&cur_state, 0, sizeof(mbstate_t));
  while (p < buf)
    {
      size_t mbclen = mbrlen(p, end - p, &cur_state);
      if (mbclen != (size_t) -2)
        prev = p;
      if (mbclen == (size_t) -1 || mbclen == (size_t) -2 || mbclen == 0)
        {
          mbclen = 1;
          memset(&cur_state, 0, sizeof cur_state);
        }
      p += mbclen;
    }
  *good = prev;
  if (p > buf)
    return true;
  return 0 < match_len && match_len < mbrlen (p, end - p, &cur_state);
}
#endif 
