#include <config.h>
#define __need_system_sys_stat_h
#include <sys/types.h>
#include <sys/stat.h>
#undef __need_system_sys_stat_h
static inline int
orig_stat (const char *filename, struct stat *buf)
{
  return stat (filename, buf);
}
#include <sys/stat.h>
#include <errno.h>
#include <limits.h>
#include <stdbool.h>
#include <string.h>
int
rpl_stat (char const *name, struct stat *st)
{
  int result = orig_stat (name, st);
#if REPLACE_FUNC_STAT_FILE
  if (result == 0 && !S_ISDIR (st->st_mode))
    {
      size_t len = strlen (name);
      if (ISSLASH (name[len - 1]))
        {
          errno = ENOTDIR;
          return -1;
        }
    }
#endif 
#if REPLACE_FUNC_STAT_DIR
  if (result == -1 && errno == ENOENT)
    {
      char fixed_name[PATH_MAX + 1] = {0};
      size_t len = strlen (name);
      bool check_dir = false;
      if (PATH_MAX <= len)
        errno = ENAMETOOLONG;
      else if (len)
        {
          strcpy (fixed_name, name);
          if (ISSLASH (fixed_name[len - 1]))
            {
              check_dir = true;
              while (len && ISSLASH (fixed_name[len - 1]))
                fixed_name[--len] = '\0';
              if (!len)
                fixed_name[0] = '/';
            }
          else
            fixed_name[len++] = '/';
          result = orig_stat (fixed_name, st);
          if (result == 0 && check_dir && !S_ISDIR (st->st_mode))
            {
              result = -1;
              errno = ENOTDIR;
            }
        }
    }
#endif 
  return result;
}
