static bool
knuth_morris_pratt_unibyte (const char *haystack, const char *needle,
                            const char **resultp)
{
  size_t m = strlen (needle);
  size_t *table = (size_t *) nmalloca (m, sizeof (size_t));
  if (table == NULL)
    return false;
  {
    size_t i, j;
    table[1] = 1;
    j = 0;
    for (i = 2; i < m; i++)
      {
        unsigned char b = CANON_ELEMENT ((unsigned char) needle[i - 1]);
        for (;;)
          {
            if (b == CANON_ELEMENT ((unsigned char) needle[j]))
              {
                table[i] = i - ++j;
                break;
              }
            if (j == 0)
              {
                table[i] = i;
                break;
              }
            j = j - table[j];
          }
      }
  }
  {
    size_t j;
    const char *rhaystack;
    const char *phaystack;
    *resultp = NULL;
    j = 0;
    rhaystack = haystack;
    phaystack = haystack;
    while (*phaystack != '\0')
      if (CANON_ELEMENT ((unsigned char) needle[j])
          == CANON_ELEMENT ((unsigned char) *phaystack))
        {
          j++;
          phaystack++;
          if (j == m)
            {
              *resultp = rhaystack;
              break;
            }
        }
      else if (j > 0)
        {
          rhaystack += table[j];
          j -= table[j];
        }
      else
        {
          rhaystack++;
          phaystack++;
        }
  }
  freea (table);
  return true;
}
#undef CANON_ELEMENT
