#include <config.h>
#include <inttypes.h>
#include <stdlib.h>
#include "verify.h"
#ifdef UNSIGNED
# ifndef HAVE_DECL_STRTOULL
"this configure-time declaration test was not run"
# endif
# if !HAVE_DECL_STRTOULL && HAVE_UNSIGNED_LONG_LONG_INT
unsigned long long int strtoull (char const *, char **, int);
# endif
#else
# ifndef HAVE_DECL_STRTOLL
"this configure-time declaration test was not run"
# endif
# if !HAVE_DECL_STRTOLL && HAVE_LONG_LONG_INT
long long int strtoll (char const *, char **, int);
# endif
#endif
#ifdef UNSIGNED
# define Have_long_long HAVE_UNSIGNED_LONG_LONG_INT
# define Int uintmax_t
# define Unsigned unsigned
# define strtoimax strtoumax
# define strtol strtoul
# define strtoll strtoull
#else
# define Have_long_long HAVE_LONG_LONG_INT
# define Int intmax_t
# define Unsigned
#endif
Int
strtoimax (char const *ptr, char **endptr, int base)
{
#if Have_long_long
  verify (sizeof (Int) == sizeof (Unsigned long int)
          || sizeof (Int) == sizeof (Unsigned long long int));
  if (sizeof (Int) != sizeof (Unsigned long int))
    return strtoll (ptr, endptr, base);
#else
  verify (sizeof (Int) == sizeof (Unsigned long int));
#endif
  return strtol (ptr, endptr, base);
}
