#include <config.h>
#include "argmatch.h"
#include <stdlib.h>
#include "progname.h"
#include "macros.h"
#ifdef ARGMATCH_DIE_DECL
#ifndef __attribute__
# if __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ < 8)
#  define __attribute__(x) 
# endif
#endif
#ifndef ATTRIBUTE_NORETURN
# define ATTRIBUTE_NORETURN __attribute__ ((__noreturn__))
#endif
ARGMATCH_DIE_DECL ATTRIBUTE_NORETURN;
ARGMATCH_DIE_DECL { exit (1); }
#endif
enum backup_type
{
  no_backups,
  simple_backups,
  numbered_existing_backups,
  numbered_backups
};
static const char *const backup_args[] =
{
  "no", "none", "off",
  "simple", "never", "single",
  "existing", "nil", "numbered-existing",
  "numbered", "t", "newstyle",
  NULL
};
static const enum backup_type backup_vals[] =
{
  no_backups, no_backups, no_backups,
  simple_backups, simple_backups, simple_backups,
  numbered_existing_backups, numbered_existing_backups, numbered_existing_backups,
  numbered_backups, numbered_backups, numbered_backups
};
int
main (int argc, char *argv[])
{
  set_program_name (argv[0]);
  ASSERT (ARGMATCH ("klingon", backup_args, backup_vals) == -1);
  ASSERT (ARGMATCH ("none", backup_args, backup_vals) == 1);
  ASSERT (ARGMATCH ("nil", backup_args, backup_vals) == 7);
  ASSERT (ARGMATCH ("nilpotent", backup_args, backup_vals) == -1);
  ASSERT (ARGMATCH ("simpl", backup_args, backup_vals) == 3);
  ASSERT (ARGMATCH ("simp", backup_args, backup_vals) == 3);
  ASSERT (ARGMATCH ("sim", backup_args, backup_vals) == 3);
  ASSERT (ARGMATCH ("numbered", backup_args, backup_vals) == 9);
  ASSERT (ARGMATCH ("numbere", backup_args, backup_vals) == -2);
  ASSERT (ARGMATCH ("number", backup_args, backup_vals) == -2);
  ASSERT (ARGMATCH ("numbe", backup_args, backup_vals) == -2);
  ASSERT (ARGMATCH ("numb", backup_args, backup_vals) == -2);
  ASSERT (ARGMATCH ("num", backup_args, backup_vals) == -2);
  ASSERT (ARGMATCH ("nu", backup_args, backup_vals) == -2);
  ASSERT (ARGMATCH ("n", backup_args, backup_vals) == -2);
  ASSERT (ARGMATCH ("ne", backup_args, backup_vals) == -2);
  ASSERT (ARGMATCH ("si", backup_args, backup_vals) == 3);
  ASSERT (ARGMATCH ("s", backup_args, backup_vals) == 3);
  return 0;
}
