#include <config.h>
#include <wchar.h>
#include "signature.h"
SIGNATURE_CHECK (btowc, wint_t, (int));
#include <locale.h>
#include <stdio.h>
#include "macros.h"
int
main (int argc, char *argv[])
{
  int c;
  if (setlocale (LC_ALL, "") == NULL)
    return 1;
  ASSERT (btowc (EOF) == WEOF);
  if (argc > 1)
    switch (argv[1][0])
      {
      case '1':
        for (c = 0; c < 0x80; c++)
          ASSERT (btowc (c) == c);
        for (c = 0xA0; c < 0x100; c++)
          ASSERT (btowc (c) != WEOF);
        return 0;
      case '2':
        for (c = 0; c < 0x80; c++)
          ASSERT (btowc (c) == c);
        for (c = 0x80; c < 0x100; c++)
          ASSERT (btowc (c) == WEOF);
        return 0;
      }
  return 1;
}
