#include <config.h>
#include <fnmatch.h>
#include "signature.h"
SIGNATURE_CHECK (fnmatch, int, (char const *, char const *, int));
#include "macros.h"
int
main ()
{
  int res;
  ASSERT (res = fnmatch ("", "", 0) == 0);
  ASSERT (res = fnmatch ("*", "", 0) == 0);
  ASSERT (res = fnmatch ("*", "foo", 0) == 0);
  ASSERT (res = fnmatch ("*", "bar", 0) == 0);
  ASSERT (res = fnmatch ("*", "*", 0) == 0);
  ASSERT (res = fnmatch ("**", "f", 0) == 0);
  ASSERT (res = fnmatch ("**", "foo.txt", 0) == 0);
  ASSERT (res = fnmatch ("*.*", "foo.txt", 0) == 0);
  ASSERT (res = fnmatch ("foo*.txt", "foobar.txt", 0) == 0);
  ASSERT (res = fnmatch ("foo.txt", "foo.txt", 0) == 0);
  ASSERT (res = fnmatch ("foo\\.txt", "foo.txt", 0) == 0);
  ASSERT (res = fnmatch ("foo\\.txt", "foo.txt", FNM_NOESCAPE) == FNM_NOMATCH);
  return 0;
}
