#include <config.h>
#define _GL_NO_LARGE_FILES
#if GNULIB_TEST_GETOPT_GNU
# include <getopt.h>
# ifndef __getopt_argv_const
#  define __getopt_argv_const const
# endif
# include "signature.h"
SIGNATURE_CHECK (getopt_long, int, (int, char *__getopt_argv_const *,
                                    char const *, struct option const *,
                                    int *));
SIGNATURE_CHECK (getopt_long_only, int, (int, char *__getopt_argv_const *,
                                         char const *, struct option const *,
                                         int *));
#endif
#include <unistd.h>
#include "signature.h"
SIGNATURE_CHECK (getopt, int, (int, char * const[], char const *));
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define BACKUP_STDERR_FILENO 10
#define ASSERT_STREAM myerr
#include "macros.h"
static FILE *myerr;
#include "test-getopt.h"
#if GNULIB_TEST_GETOPT_GNU
# include "test-getopt_long.h"
#endif
int
main (void)
{
  if (dup2 (STDERR_FILENO, BACKUP_STDERR_FILENO) != BACKUP_STDERR_FILENO
      || (myerr = fdopen (BACKUP_STDERR_FILENO, "w")) == NULL)
    return 2;
  ASSERT (freopen ("test-getopt.tmp", "w", stderr) == stderr);
  ASSERT (optind == 1);
  ASSERT (opterr != 0);
  setenv ("POSIXLY_CORRECT", "1", 1);
  test_getopt ();
#if GNULIB_TEST_GETOPT_GNU
  test_getopt_long_posix ();
#endif
  unsetenv ("POSIXLY_CORRECT");
  test_getopt ();
#if GNULIB_TEST_GETOPT_GNU
  test_getopt_long ();
  test_getopt_long_only ();
#endif
  ASSERT (fclose (stderr) == 0);
  ASSERT (remove ("test-getopt.tmp") == 0);
  return 0;
}
