#include <config.h>
#include "inttostr.h"
#include "intprops.h"
#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "macros.h"
#define STREQ(a, b) (strcmp (a, b) == 0)
#define FMT(T) (TYPE_SIGNED (T) ? "%jd" : "%ju")
#define CAST_VAL(T,V) (TYPE_SIGNED (T) ? (intmax_t) (V) : (uintmax_t) (V))
#define V_min(T) (CAST_VAL (T, TYPE_MINIMUM (T)))
#define V_max(T) (CAST_VAL (T, TYPE_MAXIMUM (T)))
#define IS_TIGHT(T) (signed_type_or_expr__(T) == TYPE_SIGNED (T))
#define ISDIGIT(c) ((unsigned int) (c) - '0' <= 9)
#define CK(T, Fn)                                                       \
  do                                                                    \
    {                                                                   \
      char ref[100];                                                    \
      char *buf = malloc (INT_BUFSIZE_BOUND (T));                       \
      char const *p;                                                    \
      ASSERT (buf);                                                     \
      *buf = '\0';                                                      \
      ASSERT (snprintf (ref, sizeof ref, FMT (T), V_min (T)) < sizeof ref); \
      ASSERT (STREQ ((p = Fn (TYPE_MINIMUM (T), buf)), ref));           \
         \
      ASSERT (! TYPE_SIGNED (T) || (p == buf && *p == '-'));            \
      ASSERT (snprintf (ref, sizeof ref, FMT (T), V_max (T)) < sizeof ref); \
      ASSERT (STREQ ((p = Fn (TYPE_MAXIMUM (T), buf)), ref));           \
               \
      ASSERT (! IS_TIGHT (T) || TYPE_SIGNED (T)                         \
              || (p == buf && ISDIGIT (*p)));                           \
      free (buf);                                                       \
    }                                                                   \
  while (0)
int
main (void)
{
  char buf[2];
  if (snprintf (buf, sizeof buf, "%ju", (uintmax_t) 3) == 1
      && buf[0] == '3' && buf[1] == '\0')
    {
      CK (int,          inttostr);
      CK (unsigned int, uinttostr);
      CK (off_t,        offtostr);
      CK (uintmax_t,    umaxtostr);
      CK (intmax_t,     imaxtostr);
      return 0;
    }
  return 77;
}
