#include <config.h>
#include <string.h>
#include <stdlib.h>
#include "macros.h"
int
main ()
{
  {
    const char input[] = "foo";
    const char *result = mbsstr (input, "");
    ASSERT (result == input);
  }
  {
    const char input[] = "foo";
    const char *result = mbsstr (input, "o");
    ASSERT (result == input + 1);
  }
  {
    const char input[] = "ABC ABCDAB ABCDABCDABDE";
    const char *result = mbsstr (input, "ABCDABD");
    ASSERT (result == input + 15);
  }
  {
    const char input[] = "ABC ABCDAB ABCDABCDABDE";
    const char *result = mbsstr (input, "ABCDABE");
    ASSERT (result == NULL);
  }
  {
    size_t repeat = 10000;
    size_t m = 1000000;
    const char *needle =
      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
    char *haystack = (char *) malloc (m + 1);
    if (haystack != NULL)
      {
        memset (haystack, 'A', m);
        haystack[0] = 'B';
        haystack[m] = '\0';
        for (; repeat > 0; repeat--)
          {
            ASSERT (mbsstr (haystack, needle) == haystack + 1);
          }
        free (haystack);
      }
  }
  {
    size_t repeat = 10000;
    size_t m = 1000000;
    const char *haystack =
      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
      "ABABABABABABABABABABABABABABABABABABABABABABABABABABABABABABABABABAB";
    char *needle = (char *) malloc (m + 1);
    if (needle != NULL)
      {
        memset (needle, 'A', m);
        needle[m] = '\0';
        for (; repeat > 0; repeat--)
          {
            ASSERT (mbsstr (haystack, needle) == NULL);
          }
        free (needle);
      }
  }
  {
    size_t m = 1000000;
    char *haystack = (char *) malloc (2 * m + 2);
    char *needle = (char *) malloc (m + 2);
    if (haystack != NULL && needle != NULL)
      {
        const char *result;
        memset (haystack, 'A', 2 * m);
        haystack[2 * m] = 'B';
        haystack[2 * m + 1] = '\0';
        memset (needle, 'A', m);
        needle[m] = 'B';
        needle[m + 1] = '\0';
        result = mbsstr (haystack, needle);
        ASSERT (result == haystack + m);
      }
    free (needle);
    free (haystack);
  }
  return 0;
}
