#include <config.h>
#include <string.h>
#include <locale.h>
#include <stdlib.h>
#include "macros.h"
int
main ()
{
  if (setlocale (LC_ALL, "") == NULL)
    return 1;
  {
    const char input[] = "f\303\266\303\266";
    const char *result = mbsstr (input, "");
    ASSERT (result == input);
  }
  {
    const char input[] = "f\303\266\303\266";
    const char *result = mbsstr (input, "\303\266");
    ASSERT (result == input + 1);
  }
  {
    const char input[] = "f\303\266\303\266";
    const char *result = mbsstr (input, "\266\303");
    ASSERT (result == NULL);
  }
  {
    const char input[] = "\303\204BC \303\204BCD\303\204B \303\204BCD\303\204BCD\303\204BDE"; 
    const char *result = mbsstr (input, "\303\204BCD\303\204BD"); 
    ASSERT (result == input + 19);
  }
  {
    const char input[] = "\303\204BC \303\204BCD\303\204B \303\204BCD\303\204BCD\303\204BDE"; 
    const char *result = mbsstr (input, "\303\204BCD\303\204BE"); 
    ASSERT (result == NULL);
  }
  {
    size_t repeat = 10000;
    size_t m = 1000000;
    const char *needle =
      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
    char *haystack = (char *) malloc (m + 1);
    if (haystack != NULL)
      {
        memset (haystack, 'A', m);
        haystack[0] = '\303'; haystack[1] = '\204';
        haystack[m] = '\0';
        for (; repeat > 0; repeat--)
          {
            ASSERT (mbsstr (haystack, needle) == haystack + 2);
          }
        free (haystack);
      }
  }
  {
    size_t repeat = 10000;
    size_t m = 1000000;
    const char *haystack =
      "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
      "A\303\207A\303\207A\303\207A\303\207A\303\207A\303\207A\303\207"
      "A\303\207A\303\207A\303\207A\303\207A\303\207A\303\207A\303\207"
      "A\303\207A\303\207A\303\207A\303\207A\303\207A\303\207A\303\207"
      "A\303\207A\303\207A\303\207A\303\207A\303\207A\303\207A\303\207"
      "A\303\207A\303\207A\303\207A\303\207A\303\207A\303\207";
    char *needle = (char *) malloc (m + 1);
    if (needle != NULL)
      {
        memset (needle, 'A', m);
        needle[m] = '\0';
        for (; repeat > 0; repeat--)
          {
            ASSERT (mbsstr (haystack, needle) == NULL);
          }
        free (needle);
      }
  }
  {
    size_t m = 1000000;
    char *haystack = (char *) malloc (2 * m + 3);
    char *needle = (char *) malloc (m + 3);
    if (haystack != NULL && needle != NULL)
      {
        const char *result;
        memset (haystack, 'A', 2 * m);
        haystack[2 * m] = '\303'; haystack[2 * m + 1] = '\207';
        haystack[2 * m + 2] = '\0';
        memset (needle, 'A', m);
        needle[m] = '\303'; needle[m + 1] = '\207';
        needle[m + 2] = '\0';
        result = mbsstr (haystack, needle);
        ASSERT (result == haystack + m);
      }
    free (needle);
    free (haystack);
  }
  return 0;
}
