#include <config.h>
#include <langinfo.h>
#include "signature.h"
SIGNATURE_CHECK (nl_langinfo, char *, (nl_item));
#include <locale.h>
#include <stdlib.h>
#include <string.h>
#include "c-strcase.h"
#include "macros.h"
int
main (int argc, char *argv[])
{
  int pass = atoi (argv[1]);
  setlocale (LC_ALL, "");
  ASSERT (strlen (nl_langinfo (CODESET)) > 0);
  if (pass == 2)
    {
      const char *codeset = nl_langinfo (CODESET);
      ASSERT (c_strcasecmp (codeset, "UTF-8") == 0 || c_strcasecmp (codeset, "UTF8") == 0);
    }
  ASSERT (strlen (nl_langinfo (RADIXCHAR)) > 0);
  ASSERT (strlen (nl_langinfo (THOUSEP)) >= 0);
  ASSERT (strlen (nl_langinfo (D_T_FMT)) > 0);
  ASSERT (strlen (nl_langinfo (D_FMT)) > 0);
  ASSERT (strlen (nl_langinfo (T_FMT)) > 0);
  ASSERT (strlen (nl_langinfo (T_FMT_AMPM)) >= (pass == 0 ? 1 : 0));
  ASSERT (strlen (nl_langinfo (AM_STR)) >= (pass == 0 ? 1 : 0));
  ASSERT (strlen (nl_langinfo (PM_STR)) >= (pass == 0 ? 1 : 0));
  ASSERT (strlen (nl_langinfo (DAY_1)) > 0);
  ASSERT (strlen (nl_langinfo (DAY_2)) > 0);
  ASSERT (strlen (nl_langinfo (DAY_3)) > 0);
  ASSERT (strlen (nl_langinfo (DAY_4)) > 0);
  ASSERT (strlen (nl_langinfo (DAY_5)) > 0);
  ASSERT (strlen (nl_langinfo (DAY_6)) > 0);
  ASSERT (strlen (nl_langinfo (DAY_7)) > 0);
  ASSERT (strlen (nl_langinfo (ABDAY_1)) > 0);
  ASSERT (strlen (nl_langinfo (ABDAY_2)) > 0);
  ASSERT (strlen (nl_langinfo (ABDAY_3)) > 0);
  ASSERT (strlen (nl_langinfo (ABDAY_4)) > 0);
  ASSERT (strlen (nl_langinfo (ABDAY_5)) > 0);
  ASSERT (strlen (nl_langinfo (ABDAY_6)) > 0);
  ASSERT (strlen (nl_langinfo (ABDAY_7)) > 0);
  ASSERT (strlen (nl_langinfo (MON_1)) > 0);
  ASSERT (strlen (nl_langinfo (MON_2)) > 0);
  ASSERT (strlen (nl_langinfo (MON_3)) > 0);
  ASSERT (strlen (nl_langinfo (MON_4)) > 0);
  ASSERT (strlen (nl_langinfo (MON_5)) > 0);
  ASSERT (strlen (nl_langinfo (MON_6)) > 0);
  ASSERT (strlen (nl_langinfo (MON_7)) > 0);
  ASSERT (strlen (nl_langinfo (MON_8)) > 0);
  ASSERT (strlen (nl_langinfo (MON_9)) > 0);
  ASSERT (strlen (nl_langinfo (MON_10)) > 0);
  ASSERT (strlen (nl_langinfo (MON_11)) > 0);
  ASSERT (strlen (nl_langinfo (MON_12)) > 0);
  ASSERT (strlen (nl_langinfo (ABMON_1)) > 0);
  ASSERT (strlen (nl_langinfo (ABMON_2)) > 0);
  ASSERT (strlen (nl_langinfo (ABMON_3)) > 0);
  ASSERT (strlen (nl_langinfo (ABMON_4)) > 0);
  ASSERT (strlen (nl_langinfo (ABMON_5)) > 0);
  ASSERT (strlen (nl_langinfo (ABMON_6)) > 0);
  ASSERT (strlen (nl_langinfo (ABMON_7)) > 0);
  ASSERT (strlen (nl_langinfo (ABMON_8)) > 0);
  ASSERT (strlen (nl_langinfo (ABMON_9)) > 0);
  ASSERT (strlen (nl_langinfo (ABMON_10)) > 0);
  ASSERT (strlen (nl_langinfo (ABMON_11)) > 0);
  ASSERT (strlen (nl_langinfo (ABMON_12)) > 0);
  ASSERT (strlen (nl_langinfo (ERA)) >= 0);
  ASSERT (strlen (nl_langinfo (ERA_D_FMT)) >= 0);
  ASSERT (strlen (nl_langinfo (ERA_D_T_FMT)) >= 0);
  ASSERT (strlen (nl_langinfo (ERA_T_FMT)) >= 0);
  ASSERT (nl_langinfo (ALT_DIGITS) != NULL);
  {
    const char *currency = nl_langinfo (CRNCYSTR);
    ASSERT (strlen (currency) >= (pass > 0 ? 1 : 0));
  }
  ASSERT (strlen (nl_langinfo (YESEXPR)) > 0);
  ASSERT (strlen (nl_langinfo (NOEXPR)) > 0);
  return 0;
}
