#include <config.h>
#include "striconv.h"
#if HAVE_ICONV
# include <iconv.h>
#endif
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include "macros.h"
int
main ()
{
#if HAVE_ICONV
  iconv_t cd_88591_to_utf8 = iconv_open ("UTF-8", "ISO-8859-1");
  iconv_t cd_utf8_to_88591 = iconv_open ("ISO-8859-1", "UTF-8");
  ASSERT (cd_88591_to_utf8 != (iconv_t)(-1));
  ASSERT (cd_utf8_to_88591 != (iconv_t)(-1));
  {
    static const char input[] = "\304rger mit b\366sen B\374bchen ohne Augenma\337";
    static const char expected[] = "\303\204rger mit b\303\266sen B\303\274bchen ohne Augenma\303\237";
    char *result = NULL;
    size_t length = 0;
    int retval = mem_cd_iconv (input, strlen (input), cd_88591_to_utf8,
                               &result, &length);
    ASSERT (retval == 0);
    ASSERT (length == strlen (expected));
    ASSERT (result != NULL && memcmp (result, expected, strlen (expected)) == 0);
    free (result);
  }
  {
    static const char input[] = "\303\204rger mit b\303\266sen B\303\274bchen ohne Augenma\303\237";
    static const char expected[] = "\304rger mit b\366sen B\374bchen ohne Augenma\337";
    char *result = NULL;
    size_t length = 0;
    int retval = mem_cd_iconv (input, strlen (input), cd_utf8_to_88591,
                               &result, &length);
    ASSERT (retval == 0);
    ASSERT (length == strlen (expected));
    ASSERT (result != NULL && memcmp (result, expected, strlen (expected)) == 0);
    free (result);
  }
  {
    static const char input[] = "\342\202\254"; 
    char *result = NULL;
    size_t length = 0;
    int retval = mem_cd_iconv (input, strlen (input), cd_utf8_to_88591,
                               &result, &length);
    ASSERT (retval == -1 && errno == EILSEQ);
    ASSERT (result == NULL);
  }
  {
    static const char input[] = "\342";
    char *result = NULL;
    size_t length = 0;
    int retval = mem_cd_iconv (input, strlen (input), cd_utf8_to_88591,
                               &result, &length);
    ASSERT (retval == 0);
    ASSERT (length == 0);
    free (result);
  }
  {
    static const char input[] = "\304rger mit b\366sen B\374bchen ohne Augenma\337";
    static const char expected[] = "\303\204rger mit b\303\266sen B\303\274bchen ohne Augenma\303\237";
    char *result = str_cd_iconv (input, cd_88591_to_utf8);
    ASSERT (result != NULL);
    ASSERT (strcmp (result, expected) == 0);
    free (result);
  }
  {
    static const char input[] = "\303\204rger mit b\303\266sen B\303\274bchen ohne Augenma\303\237";
    static const char expected[] = "\304rger mit b\366sen B\374bchen ohne Augenma\337";
    char *result = str_cd_iconv (input, cd_utf8_to_88591);
    ASSERT (result != NULL);
    ASSERT (strcmp (result, expected) == 0);
    free (result);
  }
  {
    static const char input[] = "Costs: 27 \342\202\254"; 
    char *result = str_cd_iconv (input, cd_utf8_to_88591);
    ASSERT (result == NULL && errno == EILSEQ);
  }
  {
    static const char input[] = "\342";
    char *result = str_cd_iconv (input, cd_utf8_to_88591);
    ASSERT (result != NULL);
    ASSERT (strcmp (result, "") == 0);
    free (result);
  }
  iconv_close (cd_88591_to_utf8);
  iconv_close (cd_utf8_to_88591);
  {
    static const char input[] = "\304rger mit b\366sen B\374bchen ohne Augenma\337";
    static const char expected[] = "\303\204rger mit b\303\266sen B\303\274bchen ohne Augenma\303\237";
    char *result = str_iconv (input, "ISO-8859-1", "UTF-8");
    ASSERT (result != NULL);
    ASSERT (strcmp (result, expected) == 0);
    free (result);
  }
  {
    static const char input[] = "\303\204rger mit b\303\266sen B\303\274bchen ohne Augenma\303\237";
    static const char expected[] = "\304rger mit b\366sen B\374bchen ohne Augenma\337";
    char *result = str_iconv (input, "UTF-8", "ISO-8859-1");
    ASSERT (result != NULL);
    ASSERT (strcmp (result, expected) == 0);
    free (result);
  }
  {
    static const char input[] = "Costs: 27 \342\202\254"; 
    char *result = str_iconv (input, "UTF-8", "ISO-8859-1");
    ASSERT (result == NULL && errno == EILSEQ);
  }
  {
    static const char input[] = "\342";
    char *result = str_iconv (input, "UTF-8", "ISO-8859-1");
    ASSERT (result != NULL);
    ASSERT (strcmp (result, "") == 0);
    free (result);
  }
#endif
  return 0;
}
