#include <config.h>
#include <wchar.h>
#include <errno.h>
#include <stdlib.h>
size_t
wcrtomb (char *s, wchar_t wc, mbstate_t *ps)
{
  if (ps != NULL && !mbsinit (ps))
    {
      errno = EINVAL;
      return (size_t)(-1);
    }
  if (s == NULL)
    return 1;
  else
    {
      int ret = wctomb (s, wc);
      if (ret >= 0)
        return ret;
      else
        {
          errno = EILSEQ;
          return (size_t)(-1);
        }
    }
}
