#include <config.h>
#include <wchar.h>
#include <wctype.h>
#include "localcharset.h"
#include "streq.h"
#include "uniwidth.h"
int
wcwidth (wchar_t wc)
#undef wcwidth
{
  const char *encoding = locale_charset ();
  if (STREQ (encoding, "UTF-8", 'U', 'T', 'F', '-', '8', 0, 0, 0 ,0))
    {
      return uc_width (wc, encoding);
    }
  else
    {
#if HAVE_WCWIDTH
      return wcwidth (wc);
#else
      return wc == 0 ? 0 : iswprint (wc) ? 1 : -1;
#endif
    }
}
