#include <config.h>
#if ! HAVE_INLINE
# define static_inline
#endif
#include "xalloc.h"
#undef static_inline
#include <stdlib.h>
#include <string.h>
#if defined HAVE_CALLOC_GNU || defined __GLIBC__
enum { HAVE_GNU_CALLOC = 1 };
#else
enum { HAVE_GNU_CALLOC = 0 };
#endif
void *
xmalloc (size_t n)
{
  void *p = malloc (n);
  if (!p && n != 0)
    xalloc_die ();
  return p;
}
void *
xrealloc (void *p, size_t n)
{
  p = realloc (p, n);
  if (!p && n != 0)
    xalloc_die ();
  return p;
}
void *
x2realloc (void *p, size_t *pn)
{
  return x2nrealloc (p, pn, 1);
}
void *
xzalloc (size_t s)
{
  return memset (xmalloc (s), 0, s);
}
void *
xcalloc (size_t n, size_t s)
{
  void *p;
  if ((! HAVE_GNU_CALLOC && xalloc_oversized (n, s))
      || (! (p = calloc (n, s)) && (HAVE_GNU_CALLOC || n != 0)))
    xalloc_die ();
  return p;
}
void *
xmemdup (void const *p, size_t s)
{
  return memcpy (xmalloc (s), p, s);
}
char *
xstrdup (char const *string)
{
  return xmemdup (string, strlen (string) + 1);
}
