#include <config.h>
#include "xstriconv.h"
#include <errno.h>
#include "striconv.h"
#include "xalloc.h"
#if HAVE_ICONV
int
xmem_cd_iconv (const char *src, size_t srclen, iconv_t cd,
               char **resultp, size_t *lengthp)
{
  int retval = mem_cd_iconv (src, srclen, cd, resultp, lengthp);
  if (retval < 0 && errno == ENOMEM)
    xalloc_die ();
  return retval;
}
char *
xstr_cd_iconv (const char *src, iconv_t cd)
{
  char *result = str_cd_iconv (src, cd);
  if (result == NULL && errno == ENOMEM)
    xalloc_die ();
  return result;
}
#endif
char *
xstr_iconv (const char *src, const char *from_codeset, const char *to_codeset)
{
  char *result = str_iconv (src, from_codeset, to_codeset);
  if (result == NULL && errno == ENOMEM)
    xalloc_die ();
  return result;
}
